from flask_restful import reqparse, fields, marshal_with, Resource
from eip_product import eip_db


class EipInfo(Resource):
    resource_fields = {
        "message": fields.String(default="success"),
        "status": fields.Integer(default=0),
        "data": fields.Nested(
            {"eips": fields.List(
                fields.Nested(
                    {
                        "eip": fields.String,
                        "user_name": fields.String
                    }),
            )
            })}

    @marshal_with(resource_fields)
    def get(self):
        parser = reqparse.RequestParser()
        parser.add_argument('instances_id', type=str, help='请提供eip的实例id', required=True, trim=True)
        parser.add_argument('secret_key', type=str, help='请提供凭证', required=True, trim=True)
        args = parser.parse_args()
        eip_list = []
        try:
            result = eip_db.get_eip_by_uuid(args.get("instances_id"))
            print("查询结果", result)
            if len(result) > 0:
                eip_list.append({"eip": result[0]["eip"], "user_name": result[0]["user_name"]})
                return {"data": {"eips": eip_list}}
            else:
                return {"data": {"eips": []}}
        except Exception as e:
            return {"message": '查询失败,{error}'.format(error=e)}
