from flask_sqlalchemy import SQLAlchemy
import yaml
from init import auto_man

#
with open(file='config', mode='r', encoding='utf-8') as f:
    result = yaml.load(f, Loader=yaml.FullLoader)
    db_info = result['datasource']
    print(db_info)
    DB_URI = "mysql+pymysql://{username}:{password}@{host}:{port}/{db}?charset=utf8".format(username=db_info.get("db_user"),
                                                                                            password=db_info.get("db_password"),
                                                                                            host=db_info.get("db_host"),
                                                                                            port=db_info.get("db_port"),
                                                                                            db=db_info.get("db_database"))

auto_man.config['SQLALCHEMY_DATABASE_URI'] = DB_URI
auto_man.config['SQLALCHEMY_TRACK_MODIFICATIONS'] = False

db = SQLAlchemy(auto_man)
