import json
import requests

FORBIDDEN_403 = {
    "http_code": 403,
    "code": "notAuthorized",
    "message": "You are not authorised to execute this."
}

UNAUTHORIZED_401 = {
    "http_code": 401,
    "code": "notAuthorized",
    "message": "Invalid authentication."
}

def login(username, password):
    try:
        iam_url = "https://iam.inspurcloudapi.com/auth/v1/token"
        user_data = {
            "username": username,
            "password": password
        }
        resonse = requests.post(url=iam_url, data=json.dumps(user_data))

        if resonse.ok:
            return "200"
        else:
            return "401"
    except Exception as error:
        print("当前请求token失败", error)
